package ru.yandex.qe.dispenser.client.v1.builder;

import java.util.Collection;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiPerformer;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeCause;
import ru.yandex.qe.dispenser.api.v1.request.DiEntity;
import ru.yandex.qe.dispenser.api.v1.response.DiQuotaChangeResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;

public interface BatchWeakQuotaChangeRequestBuilder extends RequestBuilder<DiQuotaChangeResponse> {
    @NotNull
    BatchWeakQuotaChangeRequestBuilder createEntity(@NotNull final DiEntity.Builder entity, @NotNull final DiPerformer performer);

    @NotNull
    BatchWeakQuotaChangeRequestBuilder createEntity(@NotNull DiEntity.Builder entity, @NotNull DiPerformer performer, @NotNull DiQuotaChangeCause cause);

    @NotNull
    default BatchWeakQuotaChangeRequestBuilder createEntities(@NotNull final Collection<DiEntity.Builder> entities, @NotNull final DiPerformer performer) {
        entities.forEach(e -> createEntity(e, performer));
        return this;
    }

    @NotNull
    default BatchWeakQuotaChangeRequestBuilder createEntities(@NotNull final Collection<DiEntity.Builder> entities, @NotNull final DiPerformer performer, @NotNull final DiQuotaChangeCause cause) {
        entities.forEach(e -> createEntity(e, performer, cause));
        return this;
    }

    @NotNull
    BatchWeakQuotaChangeRequestBuilder releaseEntity(@NotNull DiEntity.Builder entity);

    @NotNull
    BatchWeakQuotaChangeRequestBuilder releaseEntity(@NotNull DiEntity.Builder entity, @NotNull DiQuotaChangeCause cause);
}