package ru.yandex.qe.dispenser.client.v1.builder;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.request.DiEntity;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;

@SuppressWarnings("ClassReferencesSubclass")
public interface GetEntitiesRequestBuilder<B extends GetEntitiesRequestBuilder<B>> extends GetListRequestBuilder<DiListResponse<DiEntity>, B>,
        PaginatedRequestBuilder<B> {
    @NotNull
    InService<? extends B> inService(@NotNull String serviceKey);

    @NotNull
    B trashOnly();

    @NotNull
    @Override
    B page(final int pageNumber);

    @NotNull
    @Override
    B limit(final int itemsCount);

    @NotNull
    B createdFrom(final long timestamp);

    @NotNull
    B forHost(@NotNull final String host, final long startTs);

    @NotNull
    B createdTo(final long timestamp);

    interface InService<B extends InService<B>> extends GetEntitiesRequestBuilder<B> {
        @NotNull
        BySpecification bySpecification(@NotNull String specificationKey);

        interface BySpecification extends InService<BySpecification> {
            @NotNull
            RequestBuilder<DiEntity> withKey(@NotNull String key);
        }
    }
}
