package ru.yandex.qe.dispenser.client.v1.builder;

import java.util.Collection;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.response.DiEntityOwnershipResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;

@SuppressWarnings("ClassReferencesSubclass")
public interface GetEntityOwnershipsRequestBuilder<B extends GetEntityOwnershipsRequestBuilder<B>> extends RequestBuilder<DiEntityOwnershipResponse> {
    @NotNull
    GetEntityOwnershipsRequestBuilder.InService<?> inService(@NotNull String serviceKey);

    @NotNull
    B ofProject(@NotNull final String projectKey);

    @NotNull
    B forHost(@NotNull final String host, final long startTs);

    @NotNull
    B inLeafs();

    interface InService<B extends InService<B>> extends GetEntityOwnershipsRequestBuilder<B> {
        @NotNull
        BySpecification bySpecification(@NotNull String specificationKey);

        interface BySpecification extends InService<BySpecification> {
            @NotNull
            BySpecification withEntityKey(@NotNull String entityKey);

            @NotNull
            default BySpecification withEntityKeys(@NotNull final Collection<String> entityKeys) {
                entityKeys.forEach(this::withEntityKey);
                return this;
            }
        }
    }
}
