package ru.yandex.qe.dispenser.client.v1.builder;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiMetaValueSet;
import ru.yandex.qe.dispenser.api.v1.DiProjectServiceMeta;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;

@SuppressWarnings("ClassReferencesSubclass")
public interface GetProjectMetaRequestBuilder<B extends GetProjectMetaRequestBuilder<B>> extends GetListRequestBuilder<DiListResponse<DiProjectServiceMeta>, B> {
    @NotNull
    InService inService(@NotNull String serviceKey);

    interface InService extends GetProjectMetaRequestBuilder<InService> {
        @NotNull
        RequestBuilder<DiMetaValueSet> ofProject(@NotNull String projectKey);
    }
}
