package ru.yandex.qe.dispenser.client.v1.builder;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;
import ru.yandex.qe.dispenser.client.v1.impl.ProjectFilter;

public interface GetProjectsRequestBuilder<T> extends GetListRequestBuilder<DiListResponse<T>, GetProjectsRequestBuilder<T>> {
    @NotNull
    default GetProjectsRequestBuilder<T> avaliableFor(@NotNull final String memberLogin) {
        return filterBy(ProjectFilter.onlyLeafs()).filterBy(ProjectFilter.member(memberLogin));
    }

    @NotNull
    RequestBuilder<T> withKey(@NotNull final String projectKey);

    default GetProjectsRequestBuilder<T> showPersons(final boolean showPersons) {
        return filterBy(ProjectFilter.showPersons(showPersons));
    }
}
