package ru.yandex.qe.dispenser.client.v1.builder;

import java.util.Collection;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiOrder;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.client.v1.impl.ProjectFilter;
import ru.yandex.qe.dispenser.client.v1.impl.SegmentFilter;

@SuppressWarnings("ClassReferencesSubclass")
public interface GetQuotasRequestBuilder<T extends DiListResponse<?>, B extends GetQuotasRequestBuilder<T, B>> extends GetListRequestBuilder<T, B> {

    @NotNull
    GetQuotasRequestBuilder.InService<T> inService(@NotNull String serviceKey);

    default B withSegments(@NotNull final String... segmentKeys) {
        return filterBy(SegmentFilter.segments(segmentKeys));
    }

    default B withSegments(@NotNull final Collection<String> segmentKeys) {
        return filterBy(SegmentFilter.segments(segmentKeys));
    }

    @NotNull
    default B ofProject(@NotNull final String projectKey) {
        return filterBy(ProjectFilter.single(projectKey));
    }

    @NotNull
    default B orderBy(@NotNull final DiOrder orderParam) {
        return filterBy(ProjectFilter.order(orderParam));
    }

    @NotNull
    default B inLeafs() {
        return filterBy(ProjectFilter.onlyLeafs());
    }

    /**
     * @deprecated Use {@link #availableFor(String)} instead (typo fix).
     */
    @Deprecated
    @NotNull
    default B avaliableFor(@NotNull final String memeberLogin) {
        return availableFor(memeberLogin);
    }

    @NotNull
    default B availableFor(@NotNull final String memberLogin) {
        return filterBy(ProjectFilter.member(memberLogin)).inLeafs();
    }

    interface InService<T extends DiListResponse<?>> extends GetQuotasRequestBuilder<T, InService<T>>, GetListRequestBuilder<T, InService<T>> {
        @NotNull
        GetQuotasRequestBuilder.InService<T> forResource(@NotNull String resourceKey);

        /**
         * @deprecated Use {@link #byEntitySpecification(String)} instead (more comprehensive name).
         */
        @Deprecated
        @NotNull
        GetQuotasRequestBuilder.InService<T> bySpecification(@NotNull String entitySpecificationKey);

        @NotNull
        GetQuotasRequestBuilder.InService<T> byEntitySpecification(@NotNull String entitySpecificationKey);
    }
}
