package ru.yandex.qe.dispenser.client.v1.builder;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.response.DiQuotaGetResponse;
import ru.yandex.qe.dispenser.client.v1.impl.ProjectFilter;

public interface GetWeakQuotasRequestBuilder<B extends GetWeakQuotasRequestBuilder<B>> extends GetListRequestBuilder<DiQuotaGetResponse, B> {
    @NotNull
    GetWeakQuotasRequestBuilder.InService inService(@NotNull String serviceKey);

    @NotNull
    default B ofProject(@NotNull final String projectKey) {
        return filterBy(ProjectFilter.single(projectKey));
    }

    @NotNull
    default B inLeafs() {
        return filterBy(ProjectFilter.onlyLeafs());
    }

    @NotNull
    default B availableFor(@NotNull final String memberLogin) {
        return filterBy(ProjectFilter.member(memberLogin)).inLeafs();
    }

    interface InService extends GetWeakQuotasRequestBuilder<GetWeakQuotasRequestBuilder.InService>,
            GetListRequestBuilder<DiQuotaGetResponse, GetWeakQuotasRequestBuilder.InService> {
        @NotNull
        GetWeakQuotasRequestBuilder.InService forResource(@NotNull String resourceKey);

        @NotNull
        GetWeakQuotasRequestBuilder.InService byEntitySpecification(@NotNull String entitySpecificationKey);
    }
}