package ru.yandex.qe.dispenser.client.v1.builder;

import java.util.Arrays;
import java.util.Collection;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.client.v1.PersonRequestBuilder;

public interface PersonGroupModificationRequestBuilder<T> extends PersonRequestBuilder<T, PersonGroupModificationRequestBuilder<T>> {
    @NotNull
    PersonGroupModificationRequestBuilder<T> attach(@NotNull String login);

    @NotNull
    default PersonGroupModificationRequestBuilder<T> attach(@NotNull final Collection<String> logins) {
        logins.forEach(this::attach);
        return this;
    }

    @NotNull
    default PersonGroupModificationRequestBuilder<T> attach(@NotNull final String... logins) {
        return attach(Arrays.asList(logins));
    }

    @NotNull
    PersonGroupModificationRequestBuilder<T> detach(@NotNull String login);

    @NotNull
    default PersonGroupModificationRequestBuilder<T> detach(@NotNull final Collection<String> logins) {
        logins.forEach(this::detach);
        return this;
    }

    @NotNull
    default PersonGroupModificationRequestBuilder<T> detach(@NotNull final String... logins) {
        return detach(Arrays.asList(logins));
    }
}
