package ru.yandex.qe.dispenser.client.v1.builder;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiProject;
import ru.yandex.qe.dispenser.client.v1.PersonRequestBuilder;

public abstract class ProjectModificationRequestBuilder extends DiProject.BuilderBase<ProjectModificationRequestBuilder>
        implements PersonRequestBuilder<DiProject, ProjectModificationRequestBuilder> {
    @Nullable
    private String reqId;

    protected ProjectModificationRequestBuilder(final String key) {
        super(key);
    }

    @NotNull
    @Override
    public ProjectModificationRequestBuilder withReqId(final String reqId) {
        this.reqId = reqId;
        return this;
    }

    @Nullable
    protected String getReqId() {
        return reqId;
    }
}
