package ru.yandex.qe.dispenser.client.v1.builder;

import java.util.Collection;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiQuotaMaxUpdateBase;
import ru.yandex.qe.dispenser.api.v1.response.DiQuotaGetResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;
import ru.yandex.qe.dispenser.client.v1.PersonRequestBuilder;

public interface QuotaMaxUpdateRequestBuilder<T extends DiQuotaMaxUpdateBase> extends PersonRequestBuilder<DiQuotaGetResponse,
        QuotaMaxUpdateRequestBuilder<T>>, RequestBuilder<DiQuotaGetResponse> {
    @NotNull
    QuotaMaxUpdateRequestBuilder<T> updateMax(@NotNull T update);

    @NotNull
    QuotaMaxUpdateRequestBuilder<T> description(@NotNull String description);

    @NotNull
    QuotaMaxUpdateRequestBuilder<T> ticketKey(@NotNull String ticketKey);

    @NotNull
    default QuotaMaxUpdateRequestBuilder<T> updateMax(@NotNull final Collection<? extends T> updates) {
        updates.forEach(this::updateMax);
        return this;
    }
}
