package ru.yandex.qe.dispenser.client.v1.builder;

import java.util.Collection;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.request.DiActualQuotaUpdate;
import ru.yandex.qe.dispenser.api.v1.response.DiResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;
import ru.yandex.qe.dispenser.client.v1.PersonRequestBuilder;

/**
 * Interface of factory to build actual quota usage update requests.
 */
public interface SyncActualQuotasRequestBuilder extends PersonRequestBuilder<DiResponse, SyncActualQuotasRequestBuilder>, RequestBuilder<DiResponse> {

    @NotNull
    SyncActualQuotasRequestBuilder changeActualQuota(@NotNull final DiActualQuotaUpdate quotaUpdate);

    @NotNull
    default SyncActualQuotasRequestBuilder changeActualQuotas(@NotNull final Collection<DiActualQuotaUpdate> quotaUpdates) {
        quotaUpdates.forEach(this::changeActualQuota);
        return this;
    }

}
