package ru.yandex.qe.dispenser.client.v1.builder;

import java.util.Collection;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.request.DiQuotaState;
import ru.yandex.qe.dispenser.api.v1.response.DiQuotaGetResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;
import ru.yandex.qe.dispenser.client.v1.PersonRequestBuilder;

public interface SyncQuotasRequestBuilder extends PersonRequestBuilder<DiQuotaGetResponse, SyncQuotasRequestBuilder>,
        RequestBuilder<DiQuotaGetResponse> {
    @NotNull
    SyncQuotasRequestBuilder changeQuota(@NotNull DiQuotaState quotaState);

    @NotNull
    default SyncQuotasRequestBuilder changeQuotas(@NotNull final Collection<? extends DiQuotaState> quotaStates) {
        quotaStates.forEach(this::changeQuota);
        return this;
    }
}
