package ru.yandex.qe.dispenser.client.v1.builder;

import java.util.Collection;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.request.DiQuotaState;
import ru.yandex.qe.dispenser.api.v1.response.DiResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;
import ru.yandex.qe.dispenser.client.v1.PersonRequestBuilder;

/**
 * Interface of factory to build raw quota update requests.
 */
public interface SyncRawQuotasRequestBuilder extends PersonRequestBuilder<DiResponse, SyncRawQuotasRequestBuilder>, RequestBuilder<DiResponse> {

    @NotNull
    SyncRawQuotasRequestBuilder changeRawQuota(@NotNull final DiQuotaState quotaState);

    @NotNull
    default SyncRawQuotasRequestBuilder changeRawQuotas(@NotNull final Collection<DiQuotaState> quotaStates) {
        quotaStates.forEach(this::changeRawQuota);
        return this;
    }

}
