package ru.yandex.qe.dispenser.client.v1.builder;

import java.time.Duration;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.request.DiEntity;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;

@SuppressWarnings("ClassReferencesSubclass")
public interface UpdateEntitiesRequestBuilder extends RequestBuilder<DiListResponse<DiEntity>> {
    @NotNull
    InService inService(@NotNull String serviceKey);

    interface InService extends UpdateEntitiesRequestBuilder {
        @NotNull
        ByEntitySpecification bySpecification(@NotNull String entitySpecificationKey);

        interface ByEntitySpecification extends InService {
            @NotNull
            ByEntitySpecification prolong(@NotNull String entityKey, @NotNull Duration ttlFromNow);
        }
    }
}
