package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.function.Function;

import org.apache.cxf.BusException;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomJAXRSClientFactoryBean extends JAXRSClientFactoryBean {
    private static final Logger LOG = LoggerFactory.getLogger(CustomJAXRSClientFactoryBean.class);

    @NotNull
    private final Function<String, WebClient> clients;

    public CustomJAXRSClientFactoryBean(@NotNull final Function<String, WebClient> clients) {
        this.clients = clients;
    }

    @NotNull
    @Override
    public WebClient createWebClient() {
        String serviceAddress = getAddress();
        final int queryIndex = serviceAddress != null ? serviceAddress.lastIndexOf('?') : -1;
        if (queryIndex != -1) {
            serviceAddress = serviceAddress.substring(0, queryIndex);
        }
        final Service service = new JAXRSServiceImpl(serviceAddress, getServiceName());
        getServiceFactory().setService(service);

        try {
            final Endpoint ep = createEndpoint();
            this.getServiceFactory().sendEvent(FactoryBeanListener.Event.PRE_CLIENT_CREATE, ep);
            final WebClient client = clients.apply(getAddress());
            initClient(client, ep, true);

            this.getServiceFactory().sendEvent(FactoryBeanListener.Event.CLIENT_CREATED, client, ep);

            return client;
        } catch (BusException | EndpointException e) {
            LOG.error(e.getClass().getName() + " : " + e.getLocalizedMessage(), e);
            throw new RuntimeException(e);
        }
    }
}
