package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.function.Supplier;

import javax.ws.rs.HttpMethod;
import javax.ws.rs.core.GenericType;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

import ru.yandex.qe.dispenser.client.v1.DiPerson;
import ru.yandex.qe.dispenser.client.v1.builder.DeleteRequestBuilder;

final class DeleteRequestBuilderImpl<T> implements DeleteRequestBuilder<T> {
    @NotNull
    private final Supplier<WebClient> clients;
    @NotNull
    private final String path;
    private String reqId;
    private final GenericType<T> type;

    DeleteRequestBuilderImpl(@NotNull final Supplier<WebClient> clients, @NotNull final String path, @NotNull final GenericType<T> type) {
        this.clients = clients;
        this.path = path;
        this.type = type;
    }

    DeleteRequestBuilderImpl(@NotNull final Supplier<WebClient> clients, @NotNull final String path, @NotNull final Class<T> type) {
        this(clients, path, new GenericType<>(type));
    }

    @TestOnly
    @Override
    @NotNull
    public T performBy(@NotNull final DiPerson person) {
        return WebClientUtils.authenticatePerson(clients.get(), person)
                .path(path)
                .query("reqId", WebClientUtils.actualReqId(reqId))
                .header("X-Req-Id", WebClientUtils.actualReqId(reqId))
                .invoke(HttpMethod.DELETE, null, type);
    }

    @NotNull
    @Override
    public DeleteRequestBuilder<T> withReqId(@NotNull final String reqId) {
        this.reqId = reqId;
        return this;
    }
}
