package ru.yandex.qe.dispenser.client.v1.impl;

import java.net.SocketTimeoutException;

import javax.ws.rs.core.Response;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.DiRequest;
import ru.yandex.qe.dispenser.api.v1.DiPerformer;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeCause;
import ru.yandex.qe.dispenser.api.v1.request.DiActionType;
import ru.yandex.qe.dispenser.api.v1.request.DiEntity;
import ru.yandex.qe.dispenser.api.v1.request.DiEntityReference;
import ru.yandex.qe.dispenser.api.v1.request.DiEntityUsage;
import ru.yandex.qe.dispenser.api.v1.request.DiOperation;
import ru.yandex.qe.dispenser.api.v1.request.DiProcessingMode;
import ru.yandex.qe.dispenser.api.v1.request.DiResourceAmount;

public enum DiMocks {
    ;

    @NotNull
    public static ChangeQuotaRequest changeQuota(@NotNull final String serviceKey) {
        return new ChangeQuotaRequest(serviceKey);
    }

    static class Timeout<T> implements MockDispenserFactory.PerformMock<T> {
        private final long millis;

        Timeout(final long sleepBeforeTimeoutInMillis) {
            this.millis = sleepBeforeTimeoutInMillis;
        }

        @Nullable
        @Override
        public T getResponse(@NotNull final DiRequest<?> req) throws Exception {
            Thread.sleep(millis);
            throw new SocketTimeoutException();
        }
    }

    static class ServerError implements MockDispenserFactory.PerformMock<Response> {
        @Nullable
        @Override
        @SuppressWarnings("unchecked")
        public Response getResponse(@Nullable final DiRequest<?> req) {
            return Response.serverError().build();
        }
    }

    public static final class ChangeQuotaRequest {
        @NotNull
        final BatchQuotaChangeRequestBuilderImpl.BatchChangeRequestBody delegate;

        private ChangeQuotaRequest(@NotNull final String serviceKey) {
            this.delegate = new BatchQuotaChangeRequestBuilderImpl.BatchChangeRequestBody(DiProcessingMode.ROLLBACK_ON_ERROR, serviceKey);
        }

        @NotNull
        public ChangeQuotaRequest acquireResource(@NotNull final DiResourceAmount amount, final @NotNull DiPerformer performer) {
            return add(new DiOperation<>(DiActionType.FORCE_ACQUIRE_RESOURCE, amount, performer, DiQuotaChangeCause.forceAcqireResource().build()));
        }

        @NotNull
        public ChangeQuotaRequest releaseResource(@NotNull final DiResourceAmount amount, @NotNull final DiPerformer performer) {
            return add(new DiOperation<>(DiActionType.RELEASE_RESOURCE, amount, performer, DiQuotaChangeCause.releaseResource().build()));
        }

        @NotNull
        public ChangeQuotaRequest createEntity(@NotNull final DiEntity entity, final @NotNull DiPerformer performer) {
            return add(new DiOperation<>(DiActionType.CREATE_ENTITY, entity, performer, DiQuotaChangeCause.createEntity(entity, performer).build()));
        }

        @NotNull
        public ChangeQuotaRequest releaseEntity(final @NotNull DiEntityReference entity) {
            return add(new DiOperation<>(DiActionType.RELEASE_ENTITY, entity, null, DiQuotaChangeCause.releaseEntity(entity).build()));
        }

        @NotNull
        public ChangeQuotaRequest shareEntity(final @NotNull DiEntityUsage entityUsage, @NotNull final DiPerformer performer) {
            return add(new DiOperation<>(DiActionType.SHARE_ENTITY, entityUsage, performer, DiQuotaChangeCause.shareEntity(entityUsage, performer).build()));
        }

        @NotNull
        public ChangeQuotaRequest releaseEntitySharing(@NotNull final DiEntityUsage entityUsage, @NotNull final DiPerformer performer) {
            return add(new DiOperation<>(DiActionType.RELEASE_ENTITY_SHARING, entityUsage, performer, DiQuotaChangeCause.releaseEntitySharing(entityUsage, performer).build()));
        }

        @NotNull
        private ChangeQuotaRequest add(@NotNull final DiOperation<?> operation) {
            this.delegate.add(operation);
            return this;
        }
    }
}
