package ru.yandex.qe.dispenser.client.v1.impl;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;

public final class EntityFilter extends RequestFilter {
    @NotNull
    private final String serviceKey;
    @NotNull
    private final String entitySpecKey;
    @NotNull
    private final String entityKey;

    private EntityFilter(@NotNull final String serviceKey,
                         @NotNull final String entitySpecKey,
                         @NotNull final String entityKey) {
        this.serviceKey = serviceKey;
        this.entitySpecKey = entitySpecKey;
        this.entityKey = entityKey;
    }

    @NotNull
    public static EntityFilter by(@NotNull final String serviceKey, @NotNull final String entitySpecKey, @NotNull final String entityKey) {
        return new EntityFilter(serviceKey, entitySpecKey, entityKey);
    }

    @NotNull
    @Override
    WebClient apply(@NotNull final WebClient client) {
        return client.query("entity", "/" + serviceKey + "/" + entitySpecKey + "/" + entityKey);
    }
}
