package ru.yandex.qe.dispenser.client.v1.impl;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;

public final class EntitySpecFilter extends RequestFilter {
    @NotNull
    private final String serviceKey;
    @NotNull
    private final String entitySpecKey;

    private EntitySpecFilter(@NotNull final String serviceKey, @NotNull final String entitySpecKey) {
        this.serviceKey = serviceKey;
        this.entitySpecKey = entitySpecKey;
    }

    @NotNull
    public static EntitySpecFilter by(@NotNull final String serviceKey, @NotNull final String entitySpecKey) {
        return new EntitySpecFilter(serviceKey, entitySpecKey);
    }

    @NotNull
    @Override
    WebClient apply(@NotNull final WebClient client) {
        return client.query("entitySpec", "/" + serviceKey + "/" + entitySpecKey);
    }
}
