package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

import javax.ws.rs.core.GenericType;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.request.DiEntity;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.GetEntitiesRequestBuilder;

final class GetEntitiesRequestBuilderImpl extends GetListRequestBuilderBase<DiListResponse<DiEntity>, GetEntitiesRequestBuilder.InService.BySpecification> implements GetEntitiesRequestBuilder.InService.BySpecification {
    @Nullable
    private String serviceKey;
    @Nullable
    private String specificationKey;
    @Nullable
    private Integer page;
    @Nullable
    private Integer limit;
    @Nullable
    private Long createdFrom;
    @Nullable
    private Long createdTo;
    private final Map<String, Long> forHost = new HashMap<>();

    GetEntitiesRequestBuilderImpl(@NotNull final Supplier<WebClient> clients) {
        super(clients);
    }

    @NotNull
    @Override
    public GetEntitiesRequestBuilderImpl inService(@NotNull final String serviceKey) {
        this.serviceKey = serviceKey;
        return this;
    }

    @NotNull
    @Override
    public GetEntitiesRequestBuilder.InService.BySpecification bySpecification(@NotNull final String specificationKey) {
        this.specificationKey = specificationKey;
        return filterBy(EntitySpecFilter.by(Objects.requireNonNull(serviceKey, "Execute inService before!"), specificationKey));
    }

    @NotNull
    @Override
    public RequestBuilder<DiEntity> withKey(@NotNull final String key) {
        return () -> clients.get().path("/entities/" + serviceKey + "/" + specificationKey + "/" + key).get(DiEntity.class);
    }

    @NotNull
    @Override
    public GetEntitiesRequestBuilder.InService.BySpecification trashOnly() {
        return filterBy(new RequestFilter() {
            @NotNull
            @Override
            WebClient apply(@NotNull final WebClient client) {
                return client.query("trash", true);
            }
        });
    }

    @NotNull
    @Override
    public GetEntitiesRequestBuilder.InService.BySpecification page(final int pageNumber) {
        this.page = pageNumber;
        return this;
    }

    @NotNull
    @Override
    public GetEntitiesRequestBuilder.InService.BySpecification limit(final int itemsCount) {
        this.limit = itemsCount;
        return this;
    }

    @NotNull
    @Override
    public GetEntitiesRequestBuilder.InService.BySpecification forHost(@NotNull final String identifier, final long startTs) {
        this.forHost.put(identifier, startTs);
        return this;
    }

    @NotNull
    @Override
    public GetEntitiesRequestBuilder.InService.BySpecification createdFrom(final long timestamp) {
        this.createdFrom = timestamp;
        return this;
    }

    @NotNull
    @Override
    public GetEntitiesRequestBuilder.InService.BySpecification createdTo(final long timestamp) {
        this.createdTo = timestamp;
        return this;
    }

    @Override
    protected void addLazyFilters(@NotNull final Collection<RequestFilter> allFilters) {
        if (serviceKey != null && specificationKey == null) {
            allFilters.add(ServiceFilter.by(serviceKey));
        }
        if (page != null || limit != null) {
            allFilters.add(new PageFilter(page, limit));
        }
        if (createdFrom != null || createdTo != null) {
            allFilters.add(new TimeFilter(createdFrom, createdTo));
        }
    }

    @NotNull
    @Override
    protected DiListResponse<DiEntity> perform(@NotNull final WebClient filteredClient) {
        return filteredClient.path("/entities").get(new GenericType<DiListResponse<DiEntity>>() {
        });
    }
}
