package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.function.Supplier;

import javax.ws.rs.core.GenericType;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiEntitySpec;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.client.v1.builder.GetEntitySpecsRequestBuilder;

final class GetEntitySpecsRequestBuilderImpl
        extends GetListRequestBuilderBase<DiListResponse<DiEntitySpec>, GetEntitySpecsRequestBuilder> implements
        GetEntitySpecsRequestBuilder {
    GetEntitySpecsRequestBuilderImpl(@NotNull final Supplier<WebClient> clients) {
        super(clients);
    }

    @NotNull
    @Override
    protected DiListResponse<DiEntitySpec> perform(@NotNull final WebClient client) {
        return client.path("/entity-specifications").get(new GenericType<DiListResponse<DiEntitySpec>>() {
        });
    }
}
