package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.client.v1.builder.GetListRequestBuilder;

abstract class GetListRequestBuilderBase<R extends DiListResponse<?>, B extends GetListRequestBuilder<R, B>> implements GetListRequestBuilder<R, B> {
    @NotNull
    protected final Supplier<WebClient> clients;
    @NotNull
    private final List<RequestFilter> filters = new ArrayList<>();

    protected GetListRequestBuilderBase(@NotNull final Supplier<WebClient> clients) {
        this.clients = clients;
    }

    @NotNull
    @Override
    @SuppressWarnings("unchecked")
    public B filterBy(@NotNull final RequestFilter filter) {
        filters.add(filter);
        return (B) this;
    }

    protected void addLazyFilters(@NotNull final Collection<RequestFilter> allFilters) {
    }

    @NotNull
    protected abstract R perform(@NotNull final WebClient filteredClient);

    @NotNull
    @Override
    public final R perform() {
        final List<RequestFilter> allFilters = new ArrayList<>(filters);
        addLazyFilters(allFilters);
        WebClient filteredClient = clients.get();
        for (final RequestFilter filter : allFilters) {
            filteredClient = filter.apply(filteredClient);
        }
        return perform(filteredClient);
    }
}
