package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.Objects;
import java.util.function.Supplier;

import javax.ws.rs.core.GenericType;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiMetaValueSet;
import ru.yandex.qe.dispenser.api.v1.DiProjectServiceMeta;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.GetProjectMetaRequestBuilder;

final class GetProjectMetaRequestBuilderImpl extends GetListRequestBuilderBase<DiListResponse<DiProjectServiceMeta>, GetProjectMetaRequestBuilder.InService> implements GetProjectMetaRequestBuilder.InService {
    @Nullable
    private String serviceKey;

    GetProjectMetaRequestBuilderImpl(@NotNull final Supplier<WebClient> clients) {
        super(clients);
    }

    @NotNull
    @Override
    public GetProjectMetaRequestBuilder.InService inService(@NotNull final String serviceKey) {
        this.serviceKey = serviceKey;
        return filterBy(ServiceFilter.by(serviceKey));
    }

    @NotNull
    @Override
    public RequestBuilder<DiMetaValueSet> ofProject(@NotNull final String projectKey) {
        Objects.requireNonNull(serviceKey, "Execute inService before!");
        return () -> clients.get().path("/project-metas/" + serviceKey + "/" + projectKey).get(DiMetaValueSet.class);
    }

    @NotNull
    @Override
    protected DiListResponse<DiProjectServiceMeta> perform(@NotNull final WebClient filteredClient) {
        return filteredClient.path("/project-metas").get(new GenericType<DiListResponse<DiProjectServiceMeta>>() {
        });
    }
}
