package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.Arrays;
import java.util.function.Supplier;

import javax.ws.rs.core.GenericType;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.field.DiField;
import ru.yandex.qe.dispenser.api.v1.project.DiExtendedProject;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.GetProjectsRequestBuilder;

public class GetProjectsFieldsRequestBuilderImpl
        extends GetListRequestBuilderBase<DiListResponse<DiExtendedProject>, GetProjectsRequestBuilder<DiExtendedProject>>
        implements GetProjectsRequestBuilder<DiExtendedProject> {

    private final String[] fieldParams;

    protected GetProjectsFieldsRequestBuilderImpl(final @NotNull Supplier<WebClient> clients, final DiField<?>... fields) {
        super(clients);
        fieldParams = Arrays.stream(fields)
                .map(DiField::getKey)
                .toArray(String[]::new);
    }

    @Override
    public @NotNull RequestBuilder<DiExtendedProject> withKey(final @NotNull String projectKey) {
        return () -> clients.get().path("/projects/" + projectKey)
                .query("field", (Object[]) fieldParams)
                .get(DiExtendedProject.class);
    }

    @NotNull
    @Override
    public DiListResponse<DiExtendedProject> perform(final @NotNull WebClient client) {
        return client.path("/projects")
                .query("field", (Object[]) fieldParams)
                .get(new GenericType<DiListResponse<DiExtendedProject>>() {
                });
    }
}
