package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.function.Supplier;

import javax.ws.rs.core.GenericType;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiProject;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.GetProjectsRequestBuilder;

final class GetProjectsRequestBuilderImpl
        extends GetListRequestBuilderBase<DiListResponse<DiProject>, GetProjectsRequestBuilder<DiProject>>
        implements GetProjectsRequestBuilder<DiProject> {
    GetProjectsRequestBuilderImpl(@NotNull final Supplier<WebClient> clients) {
        super(clients);
    }

    @NotNull
    @Override
    public RequestBuilder<DiProject> withKey(@NotNull final String projectKey) {
        return () -> clients.get().path("/projects/" + projectKey).get(DiProject.class);
    }

    @NotNull
    @Override
    public DiListResponse<DiProject> perform(@NotNull final WebClient client) {
        return client.path("/projects").get(new GenericType<DiListResponse<DiProject>>() {
        });
    }
}
