package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import javax.ws.rs.core.GenericType;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiQuotaLightView;
import ru.yandex.qe.dispenser.api.v1.response.DiListPageResponse;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;

final class GetQuotaLightViewsRequestBuilderImpl extends GetQuotasRequestBuilderBase<DiListResponse<DiQuotaLightView>> {

    public static final GenericType<DiListPageResponse<DiQuotaLightView>> PAGE_TYPE = new GenericType<DiListPageResponse<DiQuotaLightView>>() {
    };

    GetQuotaLightViewsRequestBuilderImpl(final @NotNull Supplier<WebClient> clients) {
        super(clients);
    }

    @NotNull
    @Override
    protected DiListResponse<DiQuotaLightView> perform(final @NotNull WebClient filteredClient) {
        final WebClient client = filteredClient.replacePath("/v3/quotas/simple");

        final DiListPageItemIterator<DiQuotaLightView> iterator = new DiListPageItemIterator<>(client, PAGE_TYPE);

        final List<DiQuotaLightView> quotas = iterator.stream().collect(Collectors.toList());

        return new DiListResponse<>(quotas);
    }
}
