package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.client.v1.builder.GetQuotasRequestBuilder;

abstract class GetQuotasRequestBuilderBase<T extends DiListResponse<?>>
        extends GetListRequestBuilderBase<T, GetQuotasRequestBuilder.InService<T>>
        implements GetQuotasRequestBuilder.InService<T> {
    @Nullable
    private String serviceKey;

    protected GetQuotasRequestBuilderBase(@NotNull final Supplier<WebClient> clients) {
        super(clients);
    }

    @NotNull
    @Override
    public GetQuotasRequestBuilder.InService<T> inService(@NotNull final String serviceKey) {
        this.serviceKey = serviceKey;
        return this;
    }

    @NotNull
    @Override
    public GetQuotasRequestBuilder.InService<T> forResource(@NotNull final String resourceKey) {
        final ResourceFilter filter = ResourceFilter.singleResource(Objects.requireNonNull(serviceKey, "Execute inService before!"), resourceKey);
        serviceKey = null;
        return filterBy(filter);
    }

    @Deprecated
    @NotNull
    @Override
    public GetQuotasRequestBuilder.InService<T> bySpecification(@NotNull final String specificationKey) {
        return byEntitySpecification(specificationKey);
    }

    @Override
    public @NotNull GetQuotasRequestBuilder.InService<T> byEntitySpecification(@NotNull final String entitySpecificationKey) {
        final RequestFilter filter = EntitySpecFilter.by(Objects.requireNonNull(serviceKey, "Execute inService before!"), entitySpecificationKey);
        serviceKey = null;
        return filterBy(filter);
    }

    @Override
    protected void addLazyFilters(@NotNull final Collection<RequestFilter> allFilters) {
        if (serviceKey != null) {
            allFilters.add(ServiceFilter.by(serviceKey));
        }
    }
}
