package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.response.DiQuotaGetResponse;
import ru.yandex.qe.dispenser.client.v1.builder.GetWeakQuotasRequestBuilder;

public class GetWeakQuotasRequestBuilderImpl extends GetListRequestBuilderBase<DiQuotaGetResponse, GetWeakQuotasRequestBuilder.InService> implements GetWeakQuotasRequestBuilder.InService {
    @Nullable
    private String serviceKey;

    GetWeakQuotasRequestBuilderImpl(@NotNull final Supplier<WebClient> clients) {
        super(clients);
    }

    @NotNull
    @Override
    public GetWeakQuotasRequestBuilder.InService inService(@NotNull final String serviceKey) {
        this.serviceKey = serviceKey;
        return this;
    }

    @NotNull
    @Override
    public GetWeakQuotasRequestBuilder.InService forResource(@NotNull final String resourceKey) {
        final ResourceFilter filter = ResourceFilter.singleResource(Objects.requireNonNull(serviceKey, "Execute inService before!"), resourceKey);
        serviceKey = null;
        return filterBy(filter);
    }

    @Override
    public @NotNull GetWeakQuotasRequestBuilder.InService byEntitySpecification(@NotNull final String entitySpecificationKey) {
        final RequestFilter filter = EntitySpecFilter.by(Objects.requireNonNull(serviceKey, "Execute inService before!"), entitySpecificationKey);
        serviceKey = null;
        return filterBy(filter);
    }

    @Override
    protected void addLazyFilters(@NotNull final Collection<RequestFilter> allFilters) {
        if (serviceKey != null) {
            allFilters.add(ServiceFilter.by(serviceKey));
        }
    }

    @NotNull
    @Override
    protected DiQuotaGetResponse perform(@NotNull final WebClient filteredClient) {
        return filteredClient.path("/quotas").get(DiQuotaGetResponse.class);
    }
}
