package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.function.Supplier;

import javax.ws.rs.core.GenericType;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

import ru.yandex.qe.dispenser.client.RequestBuilder;
import ru.yandex.qe.dispenser.client.v1.DiPerson;
import ru.yandex.qe.dispenser.client.v1.Dispenser;
import ru.yandex.qe.dispenser.client.v1.builder.CreateRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.DeleteRequestBuilder;

public class ItemCrudApiImpl<T, B> implements Dispenser.ItemCrudApi<T, B> {

    protected final String path;
    protected final GenericType<T> type;
    protected final Supplier<WebClient> clients;

    protected ItemCrudApiImpl(final String path, final Class<T> type, final Supplier<WebClient> clients) {
        this(path, new GenericType<>(type), clients);
    }

    protected ItemCrudApiImpl(final String path, final GenericType<T> type, final Supplier<WebClient> clients) {
        this.path = path;
        this.type = type;
        this.clients = clients;
    }

    @TestOnly
    @Override
    public @NotNull CreateRequestBuilder<T> update(final B object) {
        return new CreateRequestBuilder<T>() {
            private String reqId;

            @NotNull
            @Override
            public T performBy(@NotNull final DiPerson person) {
                return WebClientUtils.authenticatePerson(clients.get(), person)
                        .path(path)
                        .query("reqId", WebClientUtils.actualReqId(reqId))
                        .header("X-Req-Id", WebClientUtils.actualReqId(reqId))
                        .put(object, type);
            }

            @Override
            public @NotNull CreateRequestBuilder<T> withReqId(@NotNull final String reqId) {
                this.reqId = reqId;
                return this;
            }
        };
    }

    @Override
    public @NotNull DeleteRequestBuilder<T> delete() {
        return new DeleteRequestBuilderImpl<>(clients, path, type);
    }

    @Override
    public @NotNull RequestBuilder<T> get() {
        return () -> clients.get().path(path).get(type);
    }
}
