package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.core.GenericType;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;
import ru.yandex.qe.dispenser.client.v1.DiPerson;
import ru.yandex.qe.dispenser.client.v1.Dispenser;
import ru.yandex.qe.dispenser.client.v1.builder.CreateRequestBuilder;

@ParametersAreNonnullByDefault
public abstract class ItemsCrudApiImpl<T, B, I extends Dispenser.ItemCrudApi<T, B>> implements Dispenser.ItemsCrudApi<T, B, I> {

    protected final String basePath;
    protected final Class<T> type;
    private final Supplier<WebClient> clients;

    protected ItemsCrudApiImpl(final String basePath, final Class<T> type, final Supplier<WebClient> clients) {
        this.basePath = basePath;
        this.type = type;
        this.clients = clients;
    }

    @TestOnly
    @Override
    @NotNull
    public CreateRequestBuilder<T> create(final B object) {
        return new CreateRequestBuilder<T>() {
            private String reqId;

            @NotNull
            @Override
            public T performBy(@NotNull final DiPerson person) {
                return WebClientUtils.authenticatePerson(clients.get(), person)
                        .path(basePath)
                        .query("reqId", WebClientUtils.actualReqId(reqId))
                        .header("X-Req-Id", WebClientUtils.actualReqId(reqId))
                        .post(object, type);
            }

            @Override
            public @NotNull CreateRequestBuilder<T> withReqId(@NotNull final String reqId) {
                this.reqId = reqId;
                return this;
            }
        };
    }

    @Override
    @NotNull
    public RequestBuilder<DiListResponse<T>> get() {
        return () -> clients.get().path(basePath).get(getListResponseType());
    }

    protected abstract GenericType<DiListResponse<T>> getListResponseType();

}
