package ru.yandex.qe.dispenser.client.v1.impl;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageFilter extends RequestFilter {
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer limit;

    PageFilter(@Nullable final Integer page, @Nullable final Integer limit) {
        this.page = page;
        this.limit = limit;
    }

    @Deprecated
    @NotNull
    public static PageFilter limitBy(@Nullable final Integer pageNumber, @Nullable final Integer itemsCount) {
        return new PageFilter(pageNumber, itemsCount);
    }

    @NotNull
    public static PageFilter page(final int pageNumber, final int pageSize) {
        return new PageFilter(pageNumber, pageSize);
    }

    @NotNull
    public static PageFilter page(final int pageNumber) {
        return new PageFilter(pageNumber, null);
    }

    @NotNull
    public static PageFilter limit(final int pageSize) {
        return new PageFilter(null, pageSize);
    }

    @NotNull
    @Override
    WebClient apply(@NotNull final WebClient client) {
        if (page != null) {
            client.query("page", page);
        }
        if (limit != null) {
            client.query("limit", limit);
        }
        return client;
    }
}
