package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

import ru.yandex.qe.dispenser.client.v1.DiPerson;
import ru.yandex.qe.dispenser.client.v1.builder.PersonGroupModificationRequestBuilder;

final class PersonGroupModificationRequestBuilderImpl<T> implements PersonGroupModificationRequestBuilder<T> {
    @NotNull
    private final Supplier<WebClient> clients;
    @NotNull
    private final String basePath;
    @NotNull
    private final String groupName;
    @NotNull
    private final Class<? extends T> returnType;
    @NotNull
    private final Set<String> attachedPersons;
    @NotNull
    private final Set<String> detachedPersons;
    private String reqId;

    PersonGroupModificationRequestBuilderImpl(@NotNull final Supplier<WebClient> clients, @NotNull final String basePath,
                                              @NotNull final String groupName, @NotNull final Class<? extends T> returnType) {
        this.clients = clients;
        this.basePath = basePath;
        this.groupName = groupName;
        this.returnType = returnType;
        this.attachedPersons = new HashSet<>();
        this.detachedPersons = new HashSet<>();
    }

    @NotNull
    @Override
    public PersonGroupModificationRequestBuilderImpl<T> attach(@NotNull final String login) {
        this.attachedPersons.add(login);
        return this;
    }

    @NotNull
    @Override
    public PersonGroupModificationRequestBuilderImpl<T> detach(@NotNull final String login) {
        this.detachedPersons.add(login);
        return this;
    }

    @NotNull
    @TestOnly
    @Override
    public T performBy(@NotNull final DiPerson person) {
        // TODO perform atomically
        if (!attachedPersons.isEmpty()) {
            final T attachResult = WebClientUtils.authenticatePerson(clients.get(), person)
                    .path(basePath).path("attach-" + groupName)
                    .query("reqId", WebClientUtils.actualReqId(reqId))
                    .header("X-Req-Id", WebClientUtils.actualReqId(reqId))
                    .post(attachedPersons, returnType);
            if (detachedPersons.isEmpty()) {
                return attachResult;
            }
        }
        if (!detachedPersons.isEmpty()) {
            return WebClientUtils.authenticatePerson(clients.get(), person)
                    .path(basePath).path("detach-" + groupName)
                    .query("reqId", WebClientUtils.actualReqId(reqId))
                    .header("X-Req-Id", WebClientUtils.actualReqId(reqId))
                    .post(detachedPersons, returnType);
        }
        throw new IllegalStateException("No persons specified to attach or detach");
    }

    @NotNull
    @Override
    public PersonGroupModificationRequestBuilder<T> withReqId(@NotNull final String reqId) {
        this.reqId = reqId;
        return this;
    }
}
