package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.function.Supplier;

import javax.ws.rs.core.GenericType;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiProperty;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;
import ru.yandex.qe.dispenser.client.v1.DiPerson;
import ru.yandex.qe.dispenser.client.v1.Dispenser;
import ru.yandex.qe.dispenser.client.v1.builder.SimplePersonRequestBuilder;

public class PropertyApiImpl implements Dispenser.PropertyApi {

    public static final GenericType<DiListResponse<DiProperty>> LIST_TYPE = new GenericType<DiListResponse<DiProperty>>() {
    };

    private final Supplier<WebClient> clients;
    private final String basePath;

    public PropertyApiImpl(final Supplier<WebClient> clients) {
        this.basePath = "/properties";
        this.clients = clients;
    }

    @Override
    @NotNull
    public RequestBuilder<DiProperty> getProperty(final String entityKey, final String propertyKey) {
        return () -> clients.get()
                .path(basePath)
                .query("entity", entityKey)
                .query("key", propertyKey)
                .get(LIST_TYPE).getFirst();
    }

    @Override
    @NotNull
    public RequestBuilder<DiListResponse<DiProperty>> getProperties(final String entityKey) {
        return () -> clients.get()
                .path(basePath)
                .query("entity", entityKey)
                .get(LIST_TYPE);
    }

    @Override
    @NotNull
    public <T> SimplePersonRequestBuilder<DiProperty> setProperty(final String entityKey, final String propertyKey,
                                                                  final T value) {
        return (@NotNull final DiPerson person) -> {
            return WebClientUtils.authenticatePersonWithGeneratedReqId(clients.get(), person)
                    .path(basePath)
                    .put(new DiProperty.Body(entityKey, propertyKey, value), DiProperty.class);
        };
    }

    @Override
    @NotNull
    public SimplePersonRequestBuilder<Boolean> deleteProperty(final String entityKey, final String propertyKey) {
        return (@NotNull final DiPerson person) -> {
            return WebClientUtils.authenticatePersonWithGeneratedReqId(clients.get(), person)
                    .path(basePath + "/" + entityKey + "/" + propertyKey)
                    .delete()
                    .readEntity(Boolean.class);
        };
    }
}
