package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

import ru.yandex.qe.dispenser.api.v1.DiQuotaMaxUpdateBase;
import ru.yandex.qe.dispenser.api.v1.DiQuotaMaxUpdateRequest;
import ru.yandex.qe.dispenser.api.v1.response.DiQuotaGetResponse;
import ru.yandex.qe.dispenser.client.v1.DiPerson;
import ru.yandex.qe.dispenser.client.v1.builder.QuotaMaxUpdateRequestBuilder;

final class QuotaMaxUpdateRequestBuilderImpl<T extends DiQuotaMaxUpdateBase> implements QuotaMaxUpdateRequestBuilder<T> {
    @NotNull
    private final String serviceKey;
    @NotNull
    private final Supplier<WebClient> clients;
    @Nullable
    private String reqId;

    @Nullable
    private String description;
    @Nullable
    private String ticketKey;
    @NotNull
    private final List<T> updates = new ArrayList<>();
    @NotNull
    private final String pathSuffix;

    QuotaMaxUpdateRequestBuilderImpl(@NotNull final String serviceKey, @NotNull final Supplier<WebClient> clients,
                                     @NotNull final String pathSuffix) {
        this.serviceKey = serviceKey;
        this.clients = clients;
        this.pathSuffix = pathSuffix;
    }

    @NotNull
    @Override
    public QuotaMaxUpdateRequestBuilder<T> withReqId(@NotNull final String reqId) {
        this.reqId = reqId;
        return this;
    }

    @Override
    public @NotNull QuotaMaxUpdateRequestBuilderImpl<T> updateMax(@NotNull final T update) {
        updates.add(update);
        return this;
    }

    @Override
    public @NotNull QuotaMaxUpdateRequestBuilder<T> description(@NotNull final String description) {
        this.description = description;
        return this;
    }

    @Override
    public @NotNull QuotaMaxUpdateRequestBuilder<T> ticketKey(@NotNull final String ticketKey) {
        this.ticketKey = ticketKey;
        return this;
    }

    @NotNull
    @Override
    @TestOnly
    public DiQuotaGetResponse performBy(@NotNull final DiPerson person) {
        return doPerform(WebClientUtils.authenticatePerson(clients.get(), person));
    }

    @NotNull
    @Override
    public DiQuotaGetResponse perform() {
        return doPerform(clients.get());
    }

    @NotNull
    private DiQuotaGetResponse doPerform(@NotNull final WebClient client) {
        return client.path("services/" + serviceKey + "/update-max/" + pathSuffix)
                .query("reqId", WebClientUtils.actualReqId(reqId))
                .header("X-Req-Id", WebClientUtils.actualReqId(reqId))
                .post(new DiQuotaMaxUpdateRequest<>(updates, description, ticketKey), DiQuotaGetResponse.class);
    }
}
