package ru.yandex.qe.dispenser.client.v1.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteDispenserFactory extends DispenserFactoryImpl {
    public RemoteDispenserFactory(@NotNull final DispenserConfig config) {
        super(config);
    }

    @NotNull
    @Override
    WebClient createUnconfiguredClient(@NotNull final String address) {
        return new PatchedWebClient(address);
    }

    @NotNull
    @Override
    WebClient createConfiguredWebClient() {
        final WebClient client = super.createConfiguredWebClient();

        final ClientConfiguration clientConfig = WebClient.getConfig(client);
        final HTTPConduit conduit = (HTTPConduit) clientConfig.getConduit();
        final HTTPClientPolicy clientPolicy = conduit.getClient();
        clientPolicy.setConnectionTimeout(config.getConnectionTimeout());
        clientPolicy.setReceiveTimeout(config.getReceiveTimeout());
        clientPolicy.setAutoRedirect(config.isAllowRedirects());

        return client;
    }

    static class PatchedWebClient extends WebClient {
        PatchedWebClient(@NotNull final String address) {
            super(address);
        }

        @NotNull
        @Override
        protected WebApplicationException convertToWebApplicationException(@Nullable final Response r) {
            final String errorMessage = getErrorMessage(r);
            final Class<?> exceptionClass = ExceptionUtils.getWebApplicationExceptionClass(r, WebApplicationException.class);
            try {
                final Constructor<?> ctr = exceptionClass.getConstructor(String.class, Response.class);
                return (WebApplicationException) ctr.newInstance(errorMessage, r);
            } catch (NoSuchMethodException | InstantiationException | IllegalAccessException | InvocationTargetException e) {
                return new WebApplicationException(e, r);
            }
        }

        @NotNull
        protected String getErrorMessage(@NotNull final Response r) {
            return Optional.of(r)
                    .filter(ResponseImpl.class::isInstance)
                    .map(ResponseImpl.class::cast)
                    .map(ResponseImpl::getOutMessage)
                    .map(m -> m.getContent(Exception.class))
                    .map(Exception::getMessage)
                    .orElse("No error message from server! Contact with dispenser-dev@yandex-team.ru");
        }
    }
}
