package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.Collection;
import java.util.Set;

import com.google.common.collect.Sets;
import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;

public final class SegmentFilter extends RequestFilter {
    @NotNull
    private final Set<String> segmentKeys;

    @NotNull
    public static SegmentFilter segments(final String... segmentKeys) {
        return new SegmentFilter(Sets.newHashSet(segmentKeys));
    }

    @NotNull
    public static SegmentFilter segments(final Collection<String> segmentKeys) {
        return new SegmentFilter(Sets.newHashSet(segmentKeys));
    }

    private SegmentFilter(@NotNull final Set<String> segmentKeys) {
        this.segmentKeys = segmentKeys;
    }

    @Override
    @NotNull WebClient apply(@NotNull final WebClient client) {
        return client.query("segment", segmentKeys);
    }
}
