package ru.yandex.qe.dispenser.client.v1.impl;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;

public final class ServiceFilter extends RequestFilter {
    @NotNull
    private final String serviceKey;

    private ServiceFilter(@NotNull final String serviceKey) {
        this.serviceKey = serviceKey;
    }

    @NotNull
    public static ServiceFilter by(@NotNull final String serviceKey) {
        return new ServiceFilter(serviceKey);
    }

    @NotNull
    @Override
    WebClient apply(@NotNull final WebClient client) {
        return client.query("service", serviceKey);
    }
}
