package ru.yandex.qe.dispenser.client.v1.impl;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeFilter extends RequestFilter {
    @Nullable
    private final Long from;
    @Nullable
    private final Long to;

    TimeFilter(@Nullable final Long from, @Nullable final Long to) {
        this.from = from;
        this.to = to;
    }

    @NotNull
    public static TimeFilter interval(final long from, final long to) {
        return new TimeFilter(from, to);
    }

    @NotNull
    public static TimeFilter from(final long from) {
        return new TimeFilter(from, null);
    }

    @NotNull
    public static TimeFilter to(final long to) {
        return new TimeFilter(null, to);
    }

    @NotNull
    @Override
    WebClient apply(@NotNull final WebClient client) {
        if (from != null) {
            client.query("from", from);
        }
        if (to != null) {
            client.query("to", to);
        }
        return client;
    }
}
