package ru.yandex.qe.dispenser.client.v1.impl;

import java.util.UUID;

import javax.ws.rs.core.HttpHeaders;

import org.apache.cxf.jaxrs.client.WebClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

import ru.yandex.qe.dispenser.client.v1.DiPerson;

final class WebClientUtils {
    private WebClientUtils() {
    }

    @NotNull
    @TestOnly
    public static WebClient authenticatePerson(@NotNull final WebClient webClient, @NotNull final DiPerson person) {
        return webClient.replaceHeader(HttpHeaders.AUTHORIZATION, "OAuth " + person);
    }

    @NotNull
    @TestOnly
    public static WebClient authenticatePersonWithGeneratedReqId(@NotNull final WebClient webClient, @NotNull final DiPerson person) {
        return authenticatePersonWithReqId(webClient, person, null);
    }

    @NotNull
    @TestOnly
    public static WebClient authenticatePersonWithReqId(@NotNull final WebClient webClient, @NotNull final DiPerson person,
                                                        @Nullable final String reqId) {
        return authenticatePerson(webClient, person)
                .query("reqId", actualReqId(reqId))
                .header("X-Req-Id", actualReqId(reqId));
    }

    @NotNull
    public static String actualReqId(@Nullable final String reqId) {
        return reqId != null ? reqId : generateReqId();
    }

    @NotNull
    public static String generateReqId() {
        return UUID.randomUUID().toString() + "-" + System.currentTimeMillis();
    }

}
