package ru.yandex.qe.bus;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

import javax.ws.rs.ext.ParamConverter;

import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.Period;

import ru.yandex.qe.bus.javatime.LocalDateTimeParamConverter;
import ru.yandex.qe.bus.javatime.ZonedDateTimeParamConverter;
import ru.yandex.qe.bus.joda.DateTimeParamConverter;
import ru.yandex.qe.bus.joda.DurationParamConverter;
import ru.yandex.qe.bus.joda.InstantParamConverter;
import ru.yandex.qe.bus.joda.IntervalParamConverter;
import ru.yandex.qe.bus.joda.PeriodParamConverter;

public class BusParamConverterProvider implements javax.ws.rs.ext.ParamConverterProvider {

    @Override
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        final List<Pair<Class, ParamConverter>> CLASSES_TO_CONVERTERS = Arrays.asList(
            // joda
            Pair.of(DateTime.class, new DateTimeParamConverter()),
            Pair.of(Instant.class, new InstantParamConverter()),
            Pair.of(Duration.class, new DurationParamConverter()),
            Pair.of(Period.class, new PeriodParamConverter()),
            Pair.of(Interval.class, new IntervalParamConverter()),
            // java.time
            Pair.of(java.time.ZonedDateTime.class, new ZonedDateTimeParamConverter()),
            Pair.of(java.time.LocalDateTime.class, new LocalDateTimeParamConverter()),
            Pair.of(java.time.Instant.class, new ru.yandex.qe.bus.javatime.InstantParamConverter()),
            Pair.of(java.time.Duration.class, new ru.yandex.qe.bus.javatime.DurationParamConverter())
        );

        for (Pair<Class, ParamConverter> classAndConverter : CLASSES_TO_CONVERTERS) {
            //noinspection unchecked
            if (classAndConverter.getLeft().isAssignableFrom(rawType)) {
                //noinspection unchecked
                return (ParamConverter<T>) classAndConverter.getRight();
            }
        }
        return null;
    }
}
