package ru.yandex.qe.bus;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/**
 * Established by terry
 * on 16.01.14.
 */
public class ResponseUtils {
    @Nonnull
    public static Response newResponse(@Nonnull Response.Status status,
                                        @Nullable String formatMessage,
                                        @Nonnull Object... args) {
        Response.ResponseBuilder responseBuilder = Response.status(status);
        if (formatMessage != null) {
            String message = (args.length > 0) ? String.format(formatMessage, args) : formatMessage;
            responseBuilder.entity(message);
            responseBuilder.type(MediaType.TEXT_PLAIN_TYPE);
        }
        return responseBuilder.build();
    }
}
