package ru.yandex.qe.bus;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;

import ru.yandex.qe.spring.RequestIdentity;

/**
 * @author lvovich
 */
public class Robot {

    private final String oauthToken;

    public Robot(final String oauthToken) {
        this.oauthToken = oauthToken;
    }

    public void runAuthorized(final Runnable r) {
        runAuthorized(Executors.callable(r, null));
    }

    public <V> V runAuthorized(final Callable<V> callable) {
        final RequestIdentity requestIdentity = new RequestIdentity();
        requestIdentity.setHeader("Authorization", "OAuth " + oauthToken);
        requestIdentity.enter();
        try {
            return callable.call();
        } catch (RuntimeException e) {
            throw e;
        } catch (Exception e) {
            throw new RuntimeException(e);
        } finally {
            RequestIdentity.exit();
        }
    }
}
