package ru.yandex.qe.bus.exception;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

import org.apache.cxf.jaxrs.impl.WebApplicationExceptionMapper;

/**
 * Этот маппер перекрывает стандартный {@link WebApplicationExceptionMapper}, но при этом делегирует обработку единому
 * {@link ExceptionToResponseMapper}
 *
 * @author rurikk
 */
public class WaeExceptionToResponseMapper implements ExceptionMapper<WebApplicationException> {
    private ExceptionToResponseMapper delegate = new ExceptionToResponseMapper();

    @Override
    public Response toResponse(WebApplicationException exception) {
        return delegate.toResponse(exception);
    }

    public void setDelegate(final ExceptionToResponseMapper delegate) {
        this.delegate = delegate;
    }
}
