package ru.yandex.qe.bus.factories;

import java.util.List;

import javax.inject.Inject;

import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.logging.FaultListener;
import org.apache.cxf.logging.NoOpFaultListener;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.cxf.transport.servlet.ServletDestinationFactory;
import org.springframework.beans.factory.FactoryBean;

public class BusFactoryBean implements FactoryBean<Bus> {

    private boolean useAsyncHttpClient;

    public void setUseAsyncHttpClient(final boolean useAsyncHttpClient) {
        this.useAsyncHttpClient = useAsyncHttpClient;
    }

    @Inject
    private List<Feature> features;

    @Override
    public Bus getObject() throws Exception {
        final ExtensionManagerBus cxfBus = new ExtensionManagerBus();
        cxfBus.setExtension(new ServletDestinationFactory(), HttpDestinationFactory.class);
        cxfBus.setFeatures(features);
        //HACK fix java.lang.NoClassDefFoundError: org/apache/cxf/logging/FaultListener https://st.yandex-team.ru/QESUP-2335
        cxfBus.setProperty(FaultListener.class.getName(), new NoOpFaultListener());
//        cxfBus.setProperty(AsyncHTTPConduit.USE_ASYNC, Boolean.TRUE);
        cxfBus.setProperty("org.apache.cxf.transport.http.async.usePolicy", useAsyncHttpClient ? "ALWAYS" : "NEVER");
        return cxfBus;
    }

    @Override
    public Class<?> getObjectType() {
        return Bus.class;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }
}
