package ru.yandex.qe.bus.factories.client;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

/**
 * Established by terry
 * on 30.01.14.
 */
public class BusClientSet<T> implements Iterable<Map.Entry<String, T>> {

    private final Map<String, T> address2Client;

    public BusClientSet(Map<String, T> address2Client) {
        this.address2Client = address2Client;
    }

    public T getClient(String address) {
        return address2Client.get(address);
    }

    public Map<String, T> getAddress2Client() {
        return Collections.unmodifiableMap(address2Client);
    }

    public Iterator<T> clientsIterator() {
        return address2Client.values().iterator();
    }

    @Override
    public Iterator<Map.Entry<String, T>> iterator() {
        return address2Client.entrySet().iterator();
    }
}
