package ru.yandex.qe.bus.factories.client;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.FactoryBean;

/**
 * Established by terry
 * on 30.01.14.
 */
public class BusClientSetBuilderBean extends BusClientBuilder implements FactoryBean<BusClientSet> {

    private List<String> addresses;
    private String context;

    public void setContext(String context) {
        this.context = context;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public void setAddressesCommaDelimited(String addressesCommaDelimited) {
        final String[] addressesArray = addressesCommaDelimited.split(",");
        addresses = new ArrayList<>(addressesArray.length);
        for (String address : addressesArray) {
            addresses.add(address + context);
        }
    }

    @Override
    public BusClientSet getObject() throws Exception {
        final Map<String, Object> address2Client = new HashMap<>();
        for (String address : addresses) {
            address2Client.put(address, build(address));
        }
        //noinspection unchecked
        return new BusClientSet(address2Client);
    }

    @Override
    public Class<?> getObjectType() {
        return null;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}
