package ru.yandex.qe.bus.features.links;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

import com.fasterxml.jackson.annotation.JsonProperty;

import static org.apache.commons.lang3.builder.ToStringBuilder.reflectionToString;
import static org.apache.commons.lang3.builder.ToStringStyle.SHORT_PREFIX_STYLE;

/**
 * Established by terry
 * on 15.02.14.
 */
@Immutable
public class Link {
    private String title;
    private String url;

    public Link(@JsonProperty("title") @Nonnull String title,
                @JsonProperty("url") @Nonnull String url) {
        this.title = title;
        this.url = url;
    }

    @Nonnull
    public String getTitle() {
        return title;
    }

    @Nonnull
    public String getUrl() {
        return url;
    }

    @Override
    public String toString() {
        return reflectionToString(this, SHORT_PREFIX_STYLE);
    }
}
