package ru.yandex.qe.bus.features.links;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import ru.yandex.qe.bus.MediaTypeConstants;
import ru.yandex.qe.spring.Qloud;

@Path("/links")
@Consumes(MediaType.WILDCARD)
@Produces(MediaTypeConstants.APPLICATION_JSON_WITH_UTF)
public class LinksService {

    private final List<Link> links;

    public LinksService(List<Link> links) {
        final List<Link> allLinks = new ArrayList<>(links);
        allLinks.addAll(getQloudLinks());
        this.links = allLinks;
    }

    @GET
    public List<Link> getLinks() {
        return Collections.unmodifiableList(links);
    }

    private List<Link> getQloudLinks() {
        final Qloud qloud = Qloud.get();
        if (qloud == null) {
            return Collections.emptyList();
        } else {
            return Collections.singletonList(new Link("Qloud environment",
                    "https://qloud.yandex-team.ru/projects/"+qloud.getProject()+"/"+qloud.getApplication()+"/"+qloud.getEnvironment()));
        }
    }
}
