package ru.yandex.qe.bus.features.log;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.cxf.message.Message;

/**
 * Default filter for logging on in/out cxf requests
 *
 * @author alisovenko 19.07.14
 */
public class DefaultLogInterceptFilter implements LogInterceptFilter {

    public static final String USER_AGENT = "User-Agent";

    private List<String> ignoredUserAgents = new ArrayList<>();


    public void setIgnoredUserAgents(final List<String> ignoredUserAgents) {
        this.ignoredUserAgents.addAll(ignoredUserAgents);
    }

    @Override
    public boolean acceptMessage(Message message) {
        if (message.containsKey(Message.PROTOCOL_HEADERS)) {
            @SuppressWarnings("unchecked")
            final Map<String, List<String>> headersMap = (Map<String, List<String>>) message.get(
                    Message.PROTOCOL_HEADERS);
            // Skipping any requests from health checkers
            if (isHealthMonitor(message, headersMap)) {
                return false;
            }
        }
        return true;
    }

    private boolean isHealthMonitor(Message message, Map<String, List<String>> headersMap) {
        if (message.containsKey(Message.REQUEST_URL)) {
            if (headersMap.containsKey(USER_AGENT)) {
                for (final String s : headersMap.get(USER_AGENT)) {
                    for (final String pattern : ignoredUserAgents) {
                        if (s.contains(pattern)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}
