package ru.yandex.qe.bus.features.log;

import java.util.Set;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * User: terry
 * Date: 20.09.13
 * Time: 20:19
 */
public class OnReceiveInLogInterceptor extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(OnReceiveInLogInterceptor.class);

    private final LogFeature logFeature;

    private final Set<LogInterceptFilter> filters;

    public OnReceiveInLogInterceptor(LogFeature logFeature, Set<LogInterceptFilter> filters) {
        super(Phase.RECEIVE);
        this.logFeature = logFeature;
        this.filters = filters;
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        String requestId;
        if (isRequestor(message)) {
            requestId = logFeature.findReqIdInExchange(message);
            doLogging(message, logFeature.preConstructLogLine(message, requestId).append("req-id: ").append(requestId).toString());
        } else {
            requestId = logFeature.findReqIdInHeaders(message);
            requestId = logFeature.generateReqIdIfNull(requestId);

            logFeature.putReqIdInExchange(message, requestId);
            logFeature.putReqIdInMDC(requestId);

            doLogging(message, logFeature.preConstructLogLine(message, requestId).toString());
        }
    }

    private void doLogging(Message message, String s) {
        if (!skip(message)) {
            LOG.info(s);
        }
    }

    private boolean skip(Message message) {
        for (final LogInterceptFilter filter : filters) {
            if (!filter.acceptMessage(message)) {
                // Notification for outgoing log interceptor
                message.getExchange().put(LogInterceptFilter.SKIP_LOGGING, "");

                return true;
            }
        }
        return false;
    }
}